<?php

use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Bridge\BridgeContent;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;
use Inside\Content\Models\Contents\SpacesPage;

class UpdateSpacesCategoriesPagesInSpacesPage extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();
        $bridgeContent = new BridgeContent();

        $bridge->contentTypeCreateOrUpdateField(
            type: 'spaces_page',
            fieldName: 'spaces_categories_pages',
            options: [
                'name' => 'spaces_categories_pages',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => true,
                'required' => true,
                'classifiable' => 'spaces',
                'weight' => -3,
                'title' => [
                    'fr' => 'Catégorie de pages métier'
                ],
                'description' => [
                    'fr' => 'Choix de la catégorie dans laquelle la page doit remonter',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => -3,
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['spaces_categories_pages'],
                    'cardinality' => -1,
                ],
            ],
            weight: -3
        );

        SpacesPage::with('spacesCategoriesPage')->get()->each(function ($spacesPage) use ($bridgeContent) {
            $bridgeContent->contentUpdate(
                type: 'spaces_page',
                data: [
                    'uuid' => $spacesPage->uuid,
                    'spaces_categories_pages' => $spacesPage->spacesCategoriesPage->pluck('uuid')->toArray(),
                ]
            );
        });

        $bridge->contentTypeDeleteField(
            entityType: 'node',
            type: 'spaces_page',
            fieldName: 'spaces_categories_page'
        );
    }
}
