<?php

use Inside\Host\Bridge\BridgeContentType;

$weight = 1;

return [
    'options' => [
        'searchable' => true,
        'global_searchable' => false,
        'aliasable' => false,
        'permissible' => true,
        'categorizable' => false,
        'name' => 'homepage_links',
        'listing_type' => 'content',
        'title' => [
            'fr' => 'Lien page d\'accueil',
        ],
    ],
    'fields' => [
        [
            'name' => 'image',
            'type' => BridgeContentType::IMAGE_FIELD,
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => true,
            'required' => true,
            'weight' => $weight,
            'title' => [
                'fr' => 'Image',
            ],
            'widget' => [
                'type' => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                    'preview_image_style' => 'thumbnail',
                ],
                'weight' => $weight++,
            ],
            'settings' => [
                'uri_scheme' => 'public',
                'default_image' => [
                    'uuid' => '',
                    'alt' => '',
                    'title' => '',
                    'width' => null,
                    'height' => null,
                ],
                'target_type' => 'file',
                'display_field' => false,
                'display_default' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'link_text',
            'type' => BridgeContentType::TEXT_FIELD,
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => false,
            'default' => 'voir plus',
            'required' => true,
            'weight' => $weight,
            'title' => [
                'fr' => 'Intitulé du lien',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'weight' => $weight++,
            ],
            'settings' => [
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'link',
            'type' => BridgeContentType::LINK_FIELD,
            'searchable' => false,
            'search_result_field' => false,
            'required' => true,
            'weight' => $weight,
            'title' => [
                'fr' => 'Lien',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [],
                'weight' => $weight++,
            ],
            'settings' => [
                'cardinality' => 1,
            ],
        ],
    ]
];
