<?php

use Illuminate\Support\Str;
use Inside\Host\Bridge\BridgeContent;

return [
    'files' => [
        'epar' => [
            'path' => env("EPAR_USERS_PATH", __DIR__ . '/../../../../imports/users.csv'),
            'separator' => ';',
            'fields' => [
                'name' => function ($record, BridgeContent $bridge) {
                    return trim($record['pers_libl_adrs_mail']);
                },
                'mail' => function ($record, BridgeContent $bridge) {
                    return trim($record['pers_libl_adrs_mail']);
                },
                'firstname' => function ($record, BridgeContent $bridge) {
                    return ucwords(Str::lower($record['pers_libl_prnm']));
                },
                'lastname' => function ($record, BridgeContent $bridge) {
                    return ucwords(Str::lower($record['pers_libl_nom']));
                },
                'function' => function ($record, BridgeContent $bridge) {
                    return Str::ucfirst(Str::lower($record['empl_locl_libl']));
                },
                'status' => function ($record, BridgeContent $bridge) {
                    return 1;
                },
            ]
        ]
    ]
];
