import { getContentImage } from '@inside-library/helpers/Image'

export default {
  'inside-news': {
    bookmarkEnabled: false,
    reportEnabled: false,
    dateEnabled: {
      fullPage: true,
      listingComponent: false
    }
  },
  'inside-events': {
    bookmarkEnabled: false,
    reportEnabled: false,
    calendarImportEnabled: true,
    icsTypes: [
      {
        type: 'google',
        label: 'Google'
      },
      {
        type: 'ics',
        label: 'iCalendar'
      },
      {
        type: 'outlook',
        label: 'Outlook'
      }
    ]
  },
  'inside-users': {
    shortcuts: {
      max: 4
    },
    profil: {
      enabledProfilTabs: [
        { name: 'profil', restrictions: [], icon: 'user' },
        { name: 'shortcuts', restrictions: [], icon: 'news' },
        { name: 'notifications', restrictions: [], icon: 'settings' },
        { name: 'subscriptions', restrictions: [], icon: 'tag' }
      ]
    },
    paragraphs: {
      fetchedContents: {
        display: () => import('./components/users/UserCard'),
        displayAttributes: ({ item }) => ({
          image: getContentImage(item.image, 'avatar')
        }),
        selectionConfig: {
          fields: [
            'uuid_host',
            'firstname',
            'lastname',
            { functions: ['title'] },
            { services: ['title'] },
            'image'
          ],
          filters: {
            'status:eq': 1,
            sort: 'lastname:asc',
            'is_maintenance:eq': 0
          }
        },
        requestFields: [
          'uuid',
          'firstname',
          'lastname',
          { functions: ['title'] },
          { services: ['title'] },
          'image'
        ]
      }
    }
  },
  'inside-maps': {
    mainContentType: 'markers',
    rootRoute: {
      fr: 'carte-structures'
    }
  },
  'inside-commons': {
    banner: {
      backgroundColor: 'colorSecondary',
      darkMode: false
    }
  },
  'inside-ged': {
    allowReportPictures: false
  },
  'inside-organizational-chart': {
    functionKey: 'functions'
  }
}
