import { http } from '@inside-library/helpers/Http'
import { userFields } from '../constants'

export const fetchSpaceMinimal = async ({ $route }) => {
  try {
    const { data } = await http.get('content/spaces', {
      fields: ['uuid', 'title', 'banner', 'introduction'],
      filters: { 'slug:eq': $route.params.slug }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

export const fetchSpace = async ({ $route }) => {
  try {
    const { data } = await http.get('content/spaces', {
      fields: [
        'uuid',
        'title',
        'introduction',
        'banner',
        'presentation',
        'slug',
        'content_type',
        'admin',
        {
          users: {
            fields: userFields,
            filters: { sort: 'lastname:asc' }
          }
        },
        {
          tools: [
            'uuid',
            'title',
            'image',
            'icon',
            'has_section',
            'tools_link',
            'content_type',
            'admin',
            'published_at',
            {
              tools_categories: [
                'uuid',
                { tools_categories_listings: ['uuid', 'slug'] }
              ]
            }
          ]
        },
        { structures: ['uuid', 'title', 'image', 'content_type'] },
        {
          documents: [
            'uuid',
            'title',
            'file',
            'has_section',
            'admin',
            'content_type',
            'published_at'
          ]
        },
        {
          news_categories: {
            fields: [
              'uuid',
              'title',
              {
                news: {
                  fields: [
                    'uuid',
                    'title',
                    'slug',
                    'image',
                    'chapo',
                    'content_type',
                    'published_at',
                    { news_categories: ['uuid', 'title'] }
                  ],
                  filters: {
                    reverse: true,
                    limit: 4,
                    'status:eq': 1,
                    sort: 'published_at:desc',
                    'published_at:lte': 'now()'
                  }
                }
              }
            ],
            filters: {
              'status:eq': 1,
              'published_at:lte': 'now()'
            }
          }
        },
        { pages_categories: { fields: ['count'], filters: { reverse: true } } }
      ],
      filters: { 'slug:eq': $route.params.slug }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

export const fetchFocusHomeBlock = async () => {
  try {
    const { data } = await http.get('content/focus_home', {
      fields: ['uuid', 'title', 'image', 'link'],
      filters: { 'status:eq': 1, limit: 1, sort: 'updated_at:desc' }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}
