import { userFields } from '../inside-customs/constants'

export default {
  users: {
    extendedUrl: ['uuid'],
    modalFields: [
      'uuid',
      'firstname',
      'lastname',
      'image',
      'email',
      'phone',
      'mobile_phone',
      'skills',
      { functions: ['title'] },
      { services: ['title'] },
      { structures: ['title'] },
      { users: userFields }
    ]
  },
  documents: {
    modalFields: [
      'uuid',
      'title',
      'file',
      'content',
      'published_at',
      'updated_at',
      { folders: ['title'] },
      { authors: ['uuid', 'firstname', 'lastname'] }
    ]
  },
  tools: {
    modalFields: ['uuid', 'title', 'content', 'tools_link', 'image', 'icon']
  },
  markers: {
    modalFields: [
      'uuid',
      'title',
      'content',
      'address',
      'schedules',
      'image',
      'link',
      'phone',
      'hosted_people',
      'structures_types',
      'territories',
      'departments',
      'content',
      'link_label',
      'capacity',
      { users: userFields }
    ]
  }
}
