import SpacePage from '../pages/SpacePage'
import SpacePagesPage from '../pages/SpacePagesPage'

import { fetchSpace, fetchSpaceMinimal } from '../fetch'

import { withFetch } from 'inside-collection/hocs'

export default [
  {
    name: 'HomePage',
    component: () => import('../pages/HomePage'),
    meta: { disabled: false }
  },
  {
    name: 'NewsListingPage',
    meta: { disabled: false },
    component: () => import('../pages/NewsListingPage')
  },
  {
    name: 'NewsPage',
    meta: { disabled: false }
  },
  {
    name: 'EventsCalendarPage',
    meta: { disabled: false }
  },
  {
    name: 'EventPage',
    meta: { disabled: false }
  },
  {
    name: 'DirectoryPage',
    component: () => import('../pages/DirectoryPage'),
    meta: { disabled: false }
  },
  {
    name: 'SimplePage',
    meta: { disabled: false }
  },
  {
    name: 'ToolsPage',
    meta: { disabled: false }
  },
  {
    name: 'GedPage',
    meta: { disabled: false },
    props: {
      cardOverlayEnabled: false
    }
  },
  {
    name: 'MapPage',
    component: () => import('../pages/MapPage'),
    meta: { disabled: false }
  },
  {
    name: 'SpacePage',
    path: '/espaces/:slug',
    component: withFetch(SpacePage, { size: 'xxl' })(fetchSpace)
  },
  {
    name: 'SpacePagesPage',
    path: '/espaces/:slug/pages',
    component: withFetch(SpacePagesPage, { size: 'xxl' })(fetchSpaceMinimal)
  }
]
