import { http } from '@inside-library/helpers/Http'

export default {
  spaces: {
    add: ({ data }) => ({
      name: 'SpacePage',
      params: { slug: data.slug[0] }
    })
  },
  spacesPages: {
    add: async ({ data }) => {
      const { data: spacesPages } = await http.get('content/spaces_pages', {
        fields: [
          'uuid',
          'slug',
          {
            pages_categories: [
              'uuid',
              'title',
              {
                spaces: {
                  fields: ['uuid', 'title', 'slug']
                }
              }
            ]
          }
        ],
        filters: {
          'status:eq': 1,
          'uuid:eq': data.uuid
        }
      })

      return {
        name: 'SpacePagesPage',
        params: {
          slug: spacesPages?.[0]?.pages_categories?.spaces?.slug?.[0]
        },
        query: { page: data.uuid }
      }
    },
    delete: async ({ uuid }) => {
      const { data: spacesPages } = await http.get('content/spaces_pages', {
        fields: [
          'uuid',
          'title',
          {
            pages_categories: [
              'uuid',
              'title',
              {
                spaces: {
                  fields: ['uuid', 'title', 'slug']
                }
              }
            ]
          }
        ],
        filters: {
          'status:eq': 1,
          'uuid:eq': uuid
        }
      })

      return {
        name: 'SpacePagesPage',
        params: {
          slug: spacesPages?.[0]?.pages_categories?.spaces?.slug?.[0]
        }
      }
    },
    globalSearch: () => ({
      routeAs: 'add'
    })
  },
  pagesCategories: {
    add: async ({ data }) => {
      const { data: pagesCategories } = await http.get(
        'content/pages_categories',
        {
          fields: [
            'uuid',
            'slug',
            {
              spaces: {
                fields: ['uuid', 'title', 'slug']
              }
            }
          ],
          filters: {
            'status:eq': 1,
            'uuid:eq': data.uuid
          }
        }
      )

      return {
        name: 'SpacePagesPage',
        params: {
          slug: pagesCategories?.[0]?.spaces?.slug?.[0]
        }
      }
    },
    delete: async ({ uuid }) => {
      const { data: pagesCategories } = await http.get(
        'content/pages_categories',
        {
          fields: [
            'uuid',
            {
              spaces: {
                fields: ['uuid', 'title', 'slug']
              }
            }
          ],
          filters: {
            'status:eq': 1,
            'uuid:eq': uuid
          }
        }
      )

      return {
        name: 'SpacePagesPage',
        params: {
          slug: pagesCategories?.[0]?.spaces?.slug?.[0]
        }
      }
    },
    globalSearch: () => ({
      routeAs: 'add'
    })
  },
  markers: {
    extends: 'marker'
  },
  territories: {
    extends: 'marker'
  },
  structuresTypes: {
    extends: 'marker'
  },
  departments: {
    extends: 'marker'
  },
  hostedPeople: {
    extends: 'marker'
  },
  services: {
    add: () => ({ name: 'DirectoryPage' }),
    delete: () => ({ name: 'DirectoryPage' })
  }
}
