<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\Services;
use Inside\Host\Bridge\BridgeContent;

class WipeEntriesForServices extends Migration
{
    /**
     * @throws Exception
     */
    public function up(): void
    {
        $bridge = new BridgeContent();
        Services::query()
            ->get()
            ->each(function (Services $service) use ($bridge) {
                $bridge->contentDelete($service->content_type, $service->uuid);
            });
    }
}
