<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class UpdateFunctionFieldForUsersType extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    public function up(): void
    {
        $bridge = new BridgeContentType();
        $bridge->contentTypeDeleteField('user', 'user', 'function');

        $this->bootUp(__FILE__);

        $this->migrateContent('functions');

        $this->finishUp();

        $bridge->contentTypeCreateOrUpdateField('users', 'functions', [
            'name' => 'functions',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'weight' => 3,
            'required' => false,
            'title' => [
                'fr' => 'Fonction',
            ],
            'description' => [
                'fr' => '',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 3,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['functions'],
                'cardinality' => -1,
            ],
        ]);
    }

    public function down(): void
    {
    }
}
