<?php

namespace Inside\EMMA\Providers;

use Inside\Providers\ServiceProvider as BaseServiceProvider;
use Psr\Container\ContainerExceptionInterface;
use Psr\Container\NotFoundExceptionInterface;

class ServiceProvider extends BaseServiceProvider
{
    /**
     * Boot
     */
    public function boot(): void
    {
        $this->loadMigrationsFrom(__DIR__ . '/../../database/migrations');
    }

    /**
     * Register
     */
    public function register(): void
    {
        try {
            $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/scheduler.php', 'scheduler');
            $this->mergeConfigTo(__DIR__.'/../../config/notify.php', 'notify');
            $this->mergeConfigTo(__DIR__ . '/../../config/ldap_auth.php', 'ldap_auth');
        } catch (NotFoundExceptionInterface|ContainerExceptionInterface) {
        }
    }
}
