<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class CreateProjectContentTypes extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        $bridge = new BridgeContentType();

        $bridge->contentTypeDeleteField('user', 'user', 'mobile');

        $this->migrateContent('folders');
        $this->migrateContent('documents');
        $this->migrateContent('tools_categories');
        $this->migrateContent('tools');
        $this->migrateContent('services');
        $this->migrateContent('structures');
        $this->migrateContent('custom');
        $this->migrateContent('users');
        $this->migrateContent('pages');
        $this->migrateContent('news_categories');
        $this->migrateContent('news');
        $this->migrateContent('blocks');
        $this->migrateContent('focus_home');
        $this->migrateContent('events_categories');
        $this->migrateContent('events');
        $this->migrateContent('flash_news');
        $this->migrateContent('markers');
        $this->migrateContent('spaces');
        $this->migrateContent('pages_categories');
        $this->migrateContent('spaces_pages');

        $this->finishUp();
    }
}
