<?php

use Illuminate\Support\Str;
use Adldap\Models\Entry;
use Inside\Host\Bridge\BridgeContent;

if (!function_exists('get_ldap_reference')) {
    function get_ldap_reference(Entry $user, BridgeContent $bridge, string $attribute, string $entityName): ?array
    {
        if (!$user->hasAttribute($attribute)) {
            return null;
        }

        $references = [];
        $userReferences = $user->getAttribute($attribute);
        foreach ($userReferences as $referenceName) {
            if (empty($referenceName)) {
                continue;
            }
            $referenceName = ucwords($referenceName);
            $uuid = null;
            $query = call_user_func(type_to_class($entityName) . '::query');
            $reference = $query->where('title', $referenceName)->first();

            if ($reference) {
                $uuid = $reference->uuid;
            } else {
                $uuid = $bridge->contentInsert($entityName, [
                    'type' => 'node',
                    'bundle' => $entityName,
                    'title' => $referenceName,
                ]);
            }
            $references[] = $uuid;
        }
        return $references;
    }
}

return [
    'discovering_attribute' => 'samaccountname',
    'sync_attributes' => [
        'mail' => 'mail',
        'name' => 'samaccountname',
        'firstname' => 'givenname',
        'lastname' => 'sn',
        'mobile_phone' => 'mobile',
        'phone' => 'telephonenumber',
        'functions' => function (Entry $user, BridgeContent $bridge) {
            return get_ldap_reference($user, $bridge, 'title', 'functions');
        },
        'services' => function (Entry $user, BridgeContent $bridge) {
            return get_ldap_reference($user, $bridge, 'extensionattribute10', 'services');
        },
        'categories' => function (Entry $user, BridgeContent $bridge) {
            return get_ldap_reference($user, $bridge, 'extensionattribute7', 'categories');
        },
        'contract_types' => function (Entry $user, BridgeContent $bridge) {
            return get_ldap_reference($user, $bridge, 'extensionattribute2', 'contract_types');
        },
    ]
];
