export default {
  globals: {
    calendarExportTypes: [
      {
        type: 'ics',
        label: 'iCalendar'
      }
    ]
  },
  'inside-archives': {
    isEnabled: true
  },
  'inside-commons': {
    banner: {
      darkMode: false
    }
  },
  'inside-edition': {
    duplicateEnabled: true
  },
  'inside-events': {
    showBookmarks: true,
    bookmarkEnabled: true,
    subscriptionEnabled: true
  },
  'inside-ged': {
    useBookmarks: true
  },
  'inside-news': {
    bookmarkEnabled: true,
    showBookmarks: true
  },
  'inside-users': {
    shortcuts: {
      max: 9,
      readonlyCount: 9,
      showSettings: false
    },
    profil: {
      enabledProfilTabs: [
        { name: 'profil', restrictions: [], icon: 'user' },
        { name: 'bookmarks', restrictions: [], icon: 'bookmark' },
        { name: 'password', restrictions: [], icon: 'restricted' }
      ]
    },
    paragraphs: {
      fetchedContents: {
        display: () => import('../inside-customs/components/users/Card'),
        requestFields: [
          'uuid',
          'firstname',
          'lastname',
          'image',
          'whodoeswhat',
          'phone'
        ]
      }
    }
  }
}
