import SpacePage from '../pages/spaces/SpacePage'
import SpaceCategoryPage from '../pages/spaces/SpaceCategoryPage'

import { withFetch } from 'inside-collection/hocs'

import { fetchSpacePage, fetchSpaceCategory } from '../components/spaces/fetch'

import { CONTENTS } from '@inside-ged/constants/default-contents'
const folderContents = CONTENTS()

export default [
  {
    name: 'HomePage',
    component: () => import('../pages/HomePage'),
    meta: { disabled: false }
  },
  {
    name: 'EventsCalendarPage',
    meta: { disabled: false }
  },
  {
    name: 'EventPage',
    meta: { disabled: false }
  },
  {
    name: 'EventSubscriptionPage',
    meta: { disabled: false }
  },
  {
    name: 'NewsListingPage',
    meta: { disabled: false }
  },
  {
    name: 'NewsPage',
    meta: { disabled: false }
  },
  {
    name: 'GedPage',
    meta: { disabled: false },
    props: {
      cardOverlayEnabled: false,
      folderTypes: {
        ...folderContents.folders,
        filters: {
          'status:eq': 1,
          'archived:eq': 0,
          sort: 'weight:asc'
        },
        fields: [...folderContents.folders.fields]
      }
    }
  },
  {
    name: 'DirectoryPage',
    component: () => import('../pages/directory/DirectoryPage'),
    meta: { disabled: false }
  },
  {
    name: 'ToolsPage',
    props: {
      requestFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      },
      toolsFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      }
    },
    meta: { disabled: false }
  },
  {
    name: 'SpaceCategoryPage',
    path: '/categorie-d-espace/:slug',
    component: withFetch(SpaceCategoryPage, { size: 'xxl', watch: true })(
      fetchSpaceCategory
    )
  },
  {
    name: 'SpacePage',
    path: '/espace/:slug',
    component: withFetch(SpacePage, { size: 'xxl' })(fetchSpacePage)
  },
  {
    name: 'SimplePage',
    meta: { disabled: false }
  }
]
