import { http } from '@inside-library/helpers/Http'

export default {
  tabsSpacesCategories: {
    add: async ({ data }) => {
      const { data: category } = await http.get('content/tabs_spaces_categories', {
        fields: ['uuid', 'title', 'slug'],
        filters: { 'status:eq': 1, 'uuid:eq': data.uuid }
      })

      return {
        name: 'SpaceCategoryPage',
        params: {
          slug: category?.[0].slug?.[0]
        }
      }
    }
  },
  spaces: {
    add: ({ data }) => {
      return {
        name: 'SpacePage',
        params: {
          slug: data.slug[0]
        }
      }
    },
    delete: async ({ data }) => {
      const { data: space } = await http.get('content/spaces', {
        fields: ['uuid', { spaces: ['uuid', 'title', 'slug'] }],
        filters: { 'status:eq': 1, 'uuid:eq': data.uuid }
      })

      return {
        name: 'SpaceCategoryPage',
        params: {
          slug: space?.[0].spaces?.slug?.[0]
        }
      }
    },
    globalSearch: async ({ data }) => {
      const { data: spaces } = await http.get('content/spaces', {
        fields: ['uuid', 'title', 'slug'],
        filters: { 'status:eq': 1, 'uuid:eq': data.uuid }
      })

      return {
        route: {
          name: 'SpacePage',
          params: {
            slug: spaces?.[0]?.slug?.[0]
          }
        }
      }
    }
  },
  tabs: {
    add: async ({ data }) => {
      const { data: tabs } = await http.get('content/tabs', {
        fields: ['uuid', { spaces: ['uuid', 'title', 'slug'] }],
        filters: { 'status:eq': 1, 'uuid:eq': data.uuid }
      })

      return {
        name: 'SpacePage',
        params: {
          slug: tabs[0]?.spaces.slug?.[0]
        }
      }
    },
    delete: async ({ uuid }) => {
      const { data: tabs } = await http.get('content/tabs', {
        fields: ['uuid', { spaces: ['uuid', 'title', 'slug'] }],
        filters: { 'status:eq': 1, 'uuid:eq': uuid }
      })

      return {
        name: 'SpacePage',
        params: {
          slug: tabs?.[0].spaces?.slug?.[0]
        }
      }
    },
    globalSearch: async ({ data }) => {
      const { data: tabs } = await http.get('content/tabs', {
        fields: ['uuid', { spaces: ['uuid', 'title', 'slug'] }],
        filters: { 'status:eq': 1, 'uuid:eq': data.uuid }
      })

      return {
        route: {
          name: 'SpacePage',
          params: {
            slug: tabs?.[0].spaces?.slug?.[0]
          }
        }
      }
    }
  },
  tabsPages: {
    add: async ({ data }) => {
      const { data: tabsPage } = await http.get('content/tabs_pages', {
        fields: [
          { tabs: [{ spaces: { fields: ['uuid', 'title', 'slug'] } }] }
        ],
        filters: { 'status:eq': 1, 'uuid:eq': data.uuid }
      })

      return {
        name: 'SpacePage',
        params: {
          slug: tabsPage?.[0].tabs?.spaces?.slug?.[0]
        },
        query: { page: data.uuid }
      }
    },
    delete: async ({ uuid }) => {
      const { data: tabsPage } = await http.get('content/tabs_pages', {
        fields: [
          { tabs: [{ spaces: { fields: ['uuid', 'title', 'slug'] } }] }
        ],
        filters: { 'status:eq': 1, 'uuid:eq': uuid }
      })

      return {
        name: 'SpacePage',
        params: {
          slug: tabsPage?.[0].tabs?.spaces?.slug?.[0]
        }
      }
    },
    globalSearch: async ({ data }) => {
      const { data: tabsPage } = await http.get('content/tabs_pages', {
        fields: [
          { tabs: [{ spaces: { fields: ['uuid', 'title', 'slug'] } }] }
        ],
        filters: { 'status:eq': 1, 'uuid:eq': data.uuid }
      })

      return {
        route: {
          name: 'SpacePage',
          params: {
            slug: tabsPage?.[0].tabs?.spaces?.slug?.[0]
          },
          query: { page: data.uuid }
        }
      }
    }
  }
}
