<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema;
use Inside\Content\Models\Contents\Tools;
use Inside\Content\Models\Contents\Users;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;

class AddFsaDefaultTool extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();
        $bridgeContent = new BridgeContent();

        $orderedTools = [
            'Autoprocure' => 0,
            'Firststop.fr' => 1,
            'First Stop Admin' => 2,
            'Eurofleet Tyres & Services' => 3,
            'ACR' => 4,
            'Contactez-nous' => 5,
            'YEXT' => 6,
        ];

        $tools = Tools::query()
            ->whereIn('title', array_keys($orderedTools))
            ->get()
            ->sortBy(fn (Tools $tool) => $orderedTools[$tool->title]);


        // Update tools orders
        $tools->each(
            fn (Tools $tool) => $bridgeContent->contentUpdate(
                type: 'tools',
                data: [
                    'uuid' => $tool->uuid,
                    'title' => $tool->title,
                    'weight' => $orderedTools[$tool->title]
                ]
            )
        );

        // Update global config (for newcommers)
        $bridge->contentTypeCreateOrUpdateField('users', 'tools', [
            'title' => ['fr' => 'Mes accès rapides'],
            'default' => $tools
                ->map(fn (Tools $tool) => ['target_uuid' => $tool->uuid_host])
                ->toArray(),
        ]);

        Users::all()->each(fn ($user) => $bridgeContent->updateReferenceFields(
            type: 'users',
            contentUuidHost: $user->uuid_host,
            data: [
                'tools' => $tools->pluck('uuid_host')
            ]
        ));
    }
}
