<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema;
use Inside\Content\Models\Contents\Tools;
use Inside\Content\Models\Contents\Users;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;

class AddYextDefaultTool extends Migration
{
    public function up(): void
    {
        $yext = Tools::where('title', 'YEXT')->firstOrFail()->uuid_host;
        $default = Schema::getFieldOptions('users', 'tools')['default'];
        $bridge = new BridgeContentType();
        $bridgeContent = new BridgeContent();

        // we get the last one, because the new one has to go juste before
        $last = array_splice($default, count($default) - 1);
        $default = collect(array_merge($default, [$yext], $last));

        $bridge->contentTypeCreateOrUpdateField('users', 'tools', [
            'title' => ['fr' => 'Mes accès rapides'],
            'default' => $default
                ->map(fn ($uuid) => ['target_uuid' => $uuid])
                ->toArray(),
        ]);

        Users::each(function (Users $user) use ($bridgeContent, $default) {
            $bridgeContent->contentUpdate('users', [
                'uuid' => $user->uuid,
                'tools' => $default->map(fn ($host) => Tools::where('uuid_host', $host)->firstOrFail()->uuid)->all(),
            ]);
        });
    }
}
