<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Content\Models\Contents\Users;
use Inside\Host\Bridge\BridgeContent;

class AddFieldHideInDirectoryToUsers extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            type: 'users',
            fieldName: 'hide_in_directory',
            options: [
                'name' => 'hide_in_directory',
                'searchable' => true,
                'translatable' => false,
                'search_result_field' => false,
                'searchable_filter' => true,
                'required' => false,
                'weight' => 23,
                'title' => [
                    'fr' => "Ne pas afficher dans l'annuaire",
                ],
                'description' => [
                    'fr' => 'Si cette case est cochée l\'utilisateur ne remontera pas dans l\'annuaire de l\'intranet',
                ],
                'widget' => [
                    'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                    'settings' => [
                        'display_label' => true,
                    ],
                    'weight' => 23,
                ],
                'type' => BridgeContentType::BOOLEAN_FIELD,
                'settings' => [
                    'cardinality' => 1,
                ],
                'default' => false,
            ],
        );

        $bridgeContent = new BridgeContent();

        Users::pluck('uuid')
            ->each(fn (string $uuid) => $bridgeContent->contentUpdate('users', ['uuid' => $uuid, 'hide_in_directory' => false]));
    }
}
