<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\Tools;
use Inside\Content\Models\Contents\ToolsCategories;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Content\Models\Contents\Users;

class UpdateDefaultToolsForEfsa extends Migration
{
    public function up(): void
    {
        $defaultTools = [
            'Autoprocure' => 0,
            'Firststop.fr' => 1,
            'Admin e-commerce' => 2,
            'Eurofleet Tyres & Services' => 3,
            'ACR' => 4,
            'YEXT' => 5,
            'Solocal' => 6,
            'Sésame' => 7,
            'Contactez-nous' => 8,
        ];

        $defaultToolsCategory = 'Accès rapides';

        $existingTools = Tools::query()
            ->whereIn('title', array_keys($defaultTools))
            ->get()
            ->sortBy(fn ($tool) => $defaultTools[$tool->title])
            ->pluck('title')
            ->toArray();

        $toolsToCreate = array_diff(array_keys($defaultTools), $existingTools);

        $toolsCategory = ToolsCategories::where('title', $defaultToolsCategory)->first();
        if (!$toolsCategory) {
            throw new \Exception("La catégorie d'outils '$defaultToolsCategory' n'existe pas.");
        }

        $bridge = new BridgeContent();
        collect($toolsToCreate)->each(function ($title) use ($bridge, $defaultTools, $toolsCategory) {
            $bridge->contentUpdate(
                type: 'tools',
                data: [
                    'title' => $title,
                    'weight' => $defaultTools[$title],
                    'tools_categories' => [
                        'target_uuid' => $toolsCategory->uuid,
                    ],
                ]
            );
        });


        $bridgeContentType = new BridgeContentType();

        $allTools = Tools::query()
            ->whereIn('title', array_keys($defaultTools))
            ->get()
            ->sortBy(fn ($tool) => $defaultTools[$tool->title]);

        $defaultToolsUuids = $allTools->map(
            fn ($tool) => ['target_uuid' => $tool->uuid_host]
        )->toArray();

        $bridgeContentType->contentTypeCreateOrUpdateField(
            type: 'users',
            fieldName: 'tools',
            options: [
                'title' => [
                    'fr' => 'Accès rapide',
                    'en' => 'Quick access'
                ],
                'default' => $defaultToolsUuids
            ]
        );

        Users::all()->each(fn ($user) => $bridge->updateReferenceFields(
            type: 'users',
            contentUuidHost: $user->uuid_host,
            data: [
                'tools' => $defaultToolsUuids
            ]
        ));
    }
}
