<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\Tools;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Content\Models\Contents\Users;

class AddDefaultTools extends Migration
{
    public function up(): void
    {
        $toolsTitles = [
            'Autoprocure' => 0,
            'Firststop.fr' => 1,
            'First Stop Admin' => 2,
            'Eurofleet Tyres & Services' => 3,
            'ACR' => 4,
            'YEXT' => 5,
            'Sésame' => 6,
            'Contactez-nous' => 7,
        ];

        $tools = Tools::query()
            ->whereIn('title', array_keys($toolsTitles))
            ->get()
            ->sortBy(fn (Tools $tool) => $toolsTitles[$tool->title]);

        $bridge = new BridgeContent();

        $tools->each(fn (Tools $tools) => $bridge->contentUpdate(
            type: 'tools',
            data: [
                'uuid' => $tools->uuid,
                'title' => $tools->title,
                'weight' => $toolsTitles[$tools->title],
            ]
        ));

        $bridgeContentType = new BridgeContentType();

        $defaultTools = $tools->map(fn (Tools $tool) => ['target_uuid' => $tool->uuid_host])->toArray();

        $bridgeContentType->contentTypeCreateOrUpdateField(
            type: 'users',
            fieldName: 'tools',
            options: [
                'title' => [
                    'en' => 'Quick access'
                ],
                'default' => $defaultTools
            ]
        );

        Users::all()->each(
            fn ($user) =>
             $bridge->updateReferenceFields(
                 type: 'users',
                 contentUuidHost : $user->uuid_host,
                 data: [
                        'tools' => $defaultTools
                 ]
             )
        );
    }
}
