<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Bridge\BridgeContent;

class AddNewFieldToBlocks extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField('blocks', 'display_on_mobile', [
            'name' => 'display_on_mobile',
            'searchable' => true,
            'translatable' => false,
            'search_result_field' => true,
            'search_filter' => false,
            'required' => false,
            'weight' => 8,
            'title' => [
                'fr' => 'Remonte en version mobile',
            ],
            'widget' => [
                'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [],
                'weight' => 8,
            ],
            'type' => BridgeContentType::BOOLEAN_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
            'default' => false,
        ]);

        $bridgeContent = new BridgeContent();

        type_to_class('blocks')::all()
            ->each(
                fn ($block) => $bridgeContent->contentUpdate(
                    'blocks',
                    [
                        'uuid' => $block->uuid,
                        'display_on_mobile' => false
                    ]
                )
            );
    }
}
