<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddFieldMailModalUser extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            type: 'users',
            fieldName: 'mail_modal_user',
            options: [
                'name' => 'mail_modal_user',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 20,
                'title' => [
                    'fr' => 'Mail modale utilisateur',
                ],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                    'weight' => 20,
                ],
                'type' => BridgeContentType::TEXT_FIELD,
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ],
        );
    }
}
