<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class RenameTabSpacesFieldInTabs extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeDeleteField('node', 'tabs', 'tabs_spaces');

        $bridge->contentTypeCreateOrUpdateField('tabs', 'spaces', [
            'name' => 'spaces',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 1,
            'title' => [
                'fr' => 'Espace à Onglet',
            ],
            'description' => [
                'fr' => 'Choix de l\'espace dans laquelle l\'onglet doit remonter',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 1,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['spaces'],
                'cardinality' => 1,
            ],
        ]);
    }

    public function down(): void
    {
    }
}
