<?php

declare(strict_types=1);
use Inside\Host\Bridge\BridgeContent;
use Inside\Content\Models\Contents\Users;

return [
    'files' => [
        'efsa' => [
            'path' => env('CSV_USERS_PATH', __DIR__.'/../../../../imports/import.csv'),
            'separator' => env('CSV_USERS_SEPARATOR', ';'),
            'fields' => [
                'email' => fn (array $record) => trim($record['mail']),
                'name' => fn (array $record) => trim($record['mail']),
                'firstname' => 'prenom',
                'lastname' => 'nom',
                'referent_firstname' => 'prenom pdv',
                'referent_lastname' => 'nom pdv',
                'mail_modal_user' => 'mail modale utilisateur',
                'services' => fn (array $record) => reference('services')->identifiedBy('code')->from($record['service'])->get(),
                'activities' => fn (array $record) => reference('activities')->identifiedBy('code')->from($record['activite'])->get(),
                'phone' => 'tel',
                'function' => 'fonction',
                'first_adress' => 'adresse 1',
                'second_adress' => 'adresse 2',
                'city' => 'ville',
                'departments' => fn (array $record) => reference('departments')->identifiedBy('code')->from($record['dep'])->get(),
                'whodoeswhat' => 'quoi 1',
                'company_rights' => fn (array $record) => reference('company_rights')->identifiedBy('code')->from($record['droits'])->get(),
                'status' => fn () => true,
                'send_mail' => fn ($record): bool => Users::where('email', $record['mail'])->doesntExist(),
                'hide_in_directory' => fn (array $record) => blank($record['equipes first stop']),
            ],
        ],
    ],
];
