import { http } from '@inside-library/helpers/Http'
import get from 'lodash/get'

export default {
  spaces: {
    add: ({ data }) => ({
      name: 'SpacePage',
      params: { slug: data.slug[0] }
    })
  },
  tabs: {
    fields: [{ spaces: ['slug'] }],
    add: ({ data }) => ({
      name: 'SpacePage',
      params: { slug: data.spaces.slug[0] }
    }),
    delete: ({ data }) => ({
      name: 'SpacePage',
      params: { slug: data.spaces.slug[0] }
    }),
    globalSearch: async ({ data }) => {
      const { data: Space } = await http.get('content/tabs', {
        fields: ['uuid', { spaces: ['uuid', 'title', 'slug'] }],
        filters: { 'uuid:eq': data.uuid }
      })

      return {
        route: {
          name: 'SpacePage',
          params: {
            slug: Space?.[0]?.spaces?.slug?.[0]
          },
          query: { tab: Space?.[0]?.uuid }
        }
      }
    }
  },
  spacePages: {
    fields: ['uuid', { tabs: ['uuid'] }],
    add: async ({ data }) => {
      try {
        const { data: tabs } = await http.get('content/tabs', {
          fields: [
            {
              spaces: {
                fields: ['uuid', 'title', 'slug'],
                filters: { 'status:eq': 1 }
              }
            }
          ],
          filters: { 'uuid:eq': data.tabs.uuid }
        })

        const slug = get(tabs, [0, 'spaces', 'slug', 0])

        return {
          name: 'SpaceTabsListing',
          params: { slug },
          query: { page: data.uuid }
        }
      } catch (err) {
        return { path: '/' }
      }
    },
    delete: async ({ uuid }) => {
      try {
        let { data } = await http.get('content/space_pages', {
          fields: [
            {
              tabs: {
                fields: ['uuid', 'title', 'slug'],
                filters: { 'status:eq': 1 }
              }
            }
          ],
          filters: { 'uuid:eq': uuid }
        })
        let uuidSpacePage = data[0].tabs.uuid

        data = await http.get('content/tabs', {
          fields: [
            {
              spaces: {
                fields: ['uuid', 'title', 'slug'],
                filters: { 'status:eq': 1 }
              }
            }
          ],
          filters: { 'uuid:eq': uuidSpacePage }
        })

        const slug =
          get(data, ['data', 0, 'spaces', 'slug', 0]) ||
          get(data, ['data', 0, 'spaces', 'data', 0, 'slug', 0])

        return {
          name: 'SpacePage',
          params: { slug }
        }
      } catch (err) {
        return { path: '/' }
      }
    },
    globalSearch: () => ({
      routeAs: 'add'
    })
  },
  branchesAndGroups: {
    add: ({ data }) => ({
      name: 'BranchesGroupsPage',
      params: { slug: data.slug[0] }
    }),
    delete: () => ({
      name: 'BranchesGroupsListing'
    })
  },
  statuses: {
    add: () => ({
      name: 'ProjectsListingPage'
    }),
    delete: () => ({
      name: 'ProjectsListingPage'
    })
  },
  projects: {
    add: ({ data }) => ({
      name: 'ProjectPage',
      params: { slug: data.slug[0] }
    }),
    delete: () => ({
      name: 'ProjectListingPage'
    })
  },
  projectFolders: {
    add: async ({ fields }) => {
      if (fields.projects) {
        try {
          const { data: project } = await http.get('content/projects', {
            fields: ['uuid', 'title', 'slug'],
            filters: { 'uuid:eq': fields.projects[0] }
          })

          const slug = get(project, [0, 'slug', 0])

          return {
            name: 'ProjectPage',
            params: { slug }
          }
        } catch (err) {
          return {
            name: 'ProjectsListingPage'
          }
        }
      }

      if (fields.project_folders) {
        try {
          const { data: project } = await http.get('content/project_folders', {
            fields: [
              'uuid',
              'title',
              {
                projects: ['uuid', 'title', 'slug']
              }
            ],
            filters: { 'uuid:eq': fields.project_folders }
          })

          const slug = get(project, [0, 'projects', 'data', 0, 'slug', 0])

          return {
            name: 'ProjectPage',
            params: { slug }
          }
        } catch (err) {
          return {
            name: 'ProjectsListingPage'
          }
        }
      } else {
        return {
          name: 'ProjectsListingPage'
        }
      }
    },
    delete: () => ({
      name: 'ProjectListingPage'
    })
  },
  projectDocuments: {
    add: async ({ fields }) => {
      if (!fields.project_folders) {
        return {
          name: 'ProjectsListingPage'
        }
      }

      try {
        const { data: project } = await http.get('content/project_folders', {
          fields: [
            'uuid',
            'title',
            {
              projects: ['uuid', 'title', 'slug']
            }
          ],
          filters: { 'uuid:eq': fields.project_folders }
        })

        const slug = get(project, [0, 'projects', 'data', 0, 'slug', 0])

        return {
          name: 'ProjectPage',
          params: { slug }
        }
      } catch (err) {
        return {
          name: 'ProjectsListingPage'
        }
      }
    },
    delete: () => ({
      name: 'ProjectListingPage'
    })
  },
  qualities: {
    add: ({ data }) => ({
      name: 'QualitiesPage',
      params: { slug: data.slug[0] }
    })
  },
  qualityFolders: {
    add: async ({ fields }) => {
      try {
        if (fields.qualities) {
          const { data: qualities } = await http.get('content/qualities', {
            fields: ['uuid', 'title', 'slug'],
            filters: { 'uuid:eq': fields.qualities[0] }
          })

          const slug = get(qualities, [0, 'slug', 0])

          return {
            name: 'QualitiesPage',
            params: { slug }
          }
        }

        if (fields.quality_folders) {
          const { data: qualities } = await http.get(
            'content/quality_folders',
            {
              fields: [
                'uuid',
                'title',
                {
                  qualities: ['uuid', 'title', 'slug']
                }
              ],
              filters: { 'uuid:eq': fields.quality_folders }
            }
          )

          const slug = get(qualities, [0, 'qualities', 'data', 0, 'slug', 0])

          return {
            name: 'QualitiesPage',
            params: { slug }
          }
        } else {
          return '/'
        }
      } catch (err) {
        return '/'
      }
    }
  },
  qualityDocuments: {
    add: async ({ fields }) => {
      if (!fields.quality_folders) return '/'

      try {
        const { data: qualities } = await http.get('content/quality_folders', {
          fields: [
            'uuid',
            'title',
            {
              qualities: ['uuid', 'title', 'slug']
            }
          ],
          filters: { 'uuid:eq': fields.quality_folders }
        })

        const slug = get(qualities, [0, 'qualities', 'data', 0, 'slug', 0])

        return {
          name: 'QualitiesPage',
          params: { slug }
        }
      } catch (err) {
        return '/'
      }
    }
  }
}
