import { http } from '@inside-library/helpers/Http'

export const fetchQualities = async ({ $route }) => {
  try {
    const { data } = await http.get('content/qualities', {
      fields: [
        'title',
        'uuid',
        'published_at',
        'admin',
        'content_type',
        'content',
        'slug',
        'banner',
        'description',
        'content',
        {
          quality_manager: [
            'uuid',
            'lastname',
            'firstname',
            'image',
            'function',
            'phone'
          ]
        },
        {
          users: ['uuid', 'lastname', 'firstname', 'image', 'function', 'phone']
        },
        {
          quality_documents: ['uuid', 'title', 'file']
        }
      ],
      filters: { 'slug:eq': $route.params.slug, 'status:eq': 1 }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}
