import SpacePage from '../pages/spaces/SpacePage'
import SpaceTabsListingPage from '../pages/spaces/SpaceTabsListingPage'
import BranchesGroupsListingPage from '../pages/branches-groups/BranchesGroupsListingPage'
import BranchesGroupsPage from '../pages/branches-groups/BranchesGroupsPage'
import ProjectPage from '../pages/projects/ProjectPage'
import QualitiesPage from '../pages/qualities/QualitiesPage'

import { fetchSpacePage, fetchSpaceTabs } from '../components/space/space'
import {
  fetchBranchesGroupsListing,
  fetchBranchesGroupsPage
} from '../components/branches-groups/branchesGroups'
import { fetchProject } from '../components/projects/projects'
import { fetchQualities } from '../components/qualities/qualities'

import { withFetch } from 'inside-collection/hocs'

export default [
  {
    name: 'HomePage',
    component: () => import('../pages/HomePage'),
    meta: { disabled: false }
  },
  {
    name: 'NewsListingPage',
    meta: { disabled: false },
    component: () => import('../pages/NewsListingPage')
  },
  {
    name: 'NewsPage',
    meta: { disabled: false }
  },
  {
    name: 'EventsCalendarPage',
    meta: { disabled: false }
  },
  {
    name: 'EventPage',
    meta: { disabled: false }
  },
  {
    name: 'GedPage',
    meta: { disabled: false },
    props: {
      cardOverlayEnabled: false
    }
  },
  {
    name: 'DirectoryPage',
    meta: { disabled: false },
    component: () => import('../pages/DirectoryPage')
  },
  {
    name: 'ToolsPage',
    meta: { disabled: false },
    props: {
      requestFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      },
      toolsFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      }
    }
  },
  {
    name: 'SpacePage',
    path: '/espaces/:slug',
    meta: { content: 'spaces' },
    component: withFetch(SpacePage, { size: 'xxl', watch: true })(
      fetchSpacePage
    )
  },
  {
    name: 'SpaceTabsListing',
    path: '/espaces/:slug/pages',
    component: withFetch(SpaceTabsListingPage, { size: 'xxl', watch: true })(
      fetchSpaceTabs
    )
  },
  {
    name: 'BranchesGroupsListing',
    path: '/directions-et-groupes',
    component: withFetch(BranchesGroupsListingPage, {
      size: 'xxl',
      watch: true
    })(fetchBranchesGroupsListing)
  },
  {
    name: 'BranchesGroupsPage',
    path: '/directions-et-groupes/:slug',
    component: withFetch(BranchesGroupsPage, {
      size: 'xxl',
      watch: true
    })(fetchBranchesGroupsPage)
  },
  {
    name: 'ProjectsListingPage',
    path: '/projets',
    component: () => import('../pages/projects/ProjectsListingPage')
  },
  {
    name: 'ProjectPage',
    path: '/projets/:slug',
    meta: { content: 'projects' },
    component: withFetch(ProjectPage, { size: 'xxl', watch: true })(
      fetchProject
    )
  },
  {
    name: 'QualitiesListingPage',
    path: '/qualite',
    component: () => import('../pages/qualities/QualitiesListingPage')
  },
  {
    name: 'QualitiesPage',
    path: '/qualite/:slug',
    meta: { content: 'qualities' },
    component: withFetch(QualitiesPage, { size: 'xxl', watch: true })(
      fetchQualities
    )
  },
  {
    name: 'SimplePage',
    meta: { disabled: false }
  }
]
