import { http } from '@inside-library/helpers/Http'

export const fetchProject = async ({ $route }) => {
  try {
    const { data } = await http.get('content/projects', {
      fields: [
        'title',
        'uuid',
        'published_at',
        'admin',
        'content_type',
        'content',
        'slug',
        'banner',
        'description',
        'short_summary',
        'content',
        'progress_rate',
        {
          project_manager: [
            'uuid',
            'lastname',
            'firstname',
            'image',
            'function',
            'phone'
          ]
        },
        {
          sponsors: {
            fields: [
              'uuid',
              'lastname',
              'firstname',
              'image',
              'function',
              'phone'
            ],
            filters: {
              limit: 3
            }
          }
        },
        {
          users: ['uuid', 'lastname', 'firstname', 'image', 'function', 'phone']
        },
        {
          branches_and_groups: ['uuid', 'title']
        },
        {
          project_documents: ['uuid', 'title', 'file']
        },
        {
          statuses: ['uuid', 'title', 'color']
        },
        {
          news: {
            fields: [
              'uuid',
              'title',
              'content_type',
              'slug',
              'published_at',
              'image',
              { projects: ['uuid', 'title'] }
            ],
            filters: {
              reverse: true,
              'status:eq': 1,
              sort: 'published_at:desc',
              limit: 3
            }
          }
        }
      ],
      filters: { 'slug:eq': $route.params.slug, 'status:eq': 1 }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}
