import { http } from '@inside-library/helpers/Http'

const fetchKeyNumbers = async () => {
  try {
    const { data } = await http.get('content/key_figures', {
      fields: [
        'uuid',
        'title',
        'image',
        'published_at',
        'value',
        'text',
        'content_type'
      ],
      filters: {
        'status:eq': 1,
        sort: 'published_at:desc',
        limit: 3
      }
    })

    return data
  } catch (err) {
    throw new Error(err)
  }
}

export { fetchKeyNumbers }
