import { http } from '@inside-library/helpers/Http'

export const fetchBranchesGroupsListing = async ({ $route }) => {
  try {
    const { data } = await http.get('content/branches_and_groups', {
      fields: [
        'uuid',
        'admin',
        'title',
        'slug',
        'content_type',
        'admin',
        'image',
        'preview_image'
      ],
      filters: {
        'status:eq': 1,
        sort: 'published_at:desc',
        'published_at:lte': 'now()'
      }
    })

    return data
  } catch (err) {
    throw new Error(err)
  }
}

export const fetchBranchesGroupsPage = async ({ $route }) => {
  try {
    let folderContent = null

    const { data } = await http.get('content/branches_and_groups', {
      fields: [
        'uuid',
        'admin',
        'title',
        'slug',
        'content_type',
        'branches_introduction',
        'banner',
        'admin',
        'key_contact_image',
        {
          branches_folders: {
            fields: [
              'title',
              'uuid',
              'admin',
              'image',
              'icon',
              'color',
              'content_type'
            ],
            filters: {
              'status:eq': 1
            }
          }
        },
        {
          news: {
            fields: [
              'uuid',
              'title',
              'slug',
              'chapo',
              'published_at',
              'image',
              'content_type',
              {
                branches_and_groups: {
                  fields: ['uuid', 'title', 'slug'],
                  filters: { 'status:eq': 1 }
                }
              },
              { reactions: ['count', { users: ['uuid'] }] },
              { comments: ['count'] }
            ],
            filters: {
              reverse: true,
              'status:eq': 1,
              sort: 'published_at:desc',
              limit: 4
            }
          }
        },
        {
          users: {
            fields: [
              'uuid',
              'firstname',
              'lastname',
              'image',
              'function',
              'phone'
            ],
            filters: {
              'status:eq': 1
            }
          }
        }
      ],
      filters: { 'slug:eq': $route.params.slug }
    })

    if (data[0].branches_folders) {
      const { data: documents } = await http.get('content/documents', {
        fields: [
          'uuid',
          'admin',
          'title',
          'content_type',
          'admin',
          'file',
          'content',
          {
            folders: {
              fields: ['title', 'uuid', 'admin', 'content_type'],
              filters: {
                'status:eq': 1
              }
            }
          }
        ],
        filters: {
          folders: {
            'uuid:in': data[0]?.branches_folders?.data.map(data => data.uuid),
            sort: 'published_at:desc'
          }
        }
      })

      const { data: subfolders } = await http.get('content/folders', {
        fields: [
          'uuid',
          'admin',
          'title',
          'content_type',
          'admin',
          'image',
          'icon',
          'color',
          {
            folders: {
              fields: ['title', 'uuid', 'admin', 'content_type'],
              filters: {
                'status:eq': 1
              }
            }
          }
        ],
        filters: {
          'pid:in': data[0]?.branches_folders?.data.map(data => data.uuid),
          sort: 'published_at:desc'
        }
      })

      folderContent = { documents, subfolders }
    }

    return { ...data[0], ...folderContent }
  } catch (err) {
    throw new Error(err)
  }
}
