<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddAlphabetBooksTags extends Migration
{
    public function up(): void
    {
        $bridgeContentType = new BridgeContentType();

        $bridgeContentType->contentTypeUpdateOrCreate(
            type: 'alphabet_books_tags',
            options: [
                'name' => 'alphabet_books_tags',
                'translatable' => true,
                'searchable' => true,
                'global_searchable' => false,
                'aliasable' => false,
                'permissible' => false,
                'categorizable' => false,
                'listing_type' => 'taxo',
                'title' => [
                    'fr' => 'Tag d\'abécédaire',
                    'en' => 'Alphabet book tag',
                    'de' => 'Alphabetbuch-Tag',
                    'nl' => 'Alfabetboek tag',
                    'es' => 'Etiqueta de libro de alfabeto',
                    'pt' => 'Tag de livro de alfabeto',
                ],
            ],
        );

        $bridgeContentType->contentTypeCreateOrUpdateField(
            type: 'alphabet_books',
            fieldName: 'alphabet_books_tags',
            options: [
                'name' => 'alphabet_books_tags',
                'searchable' => true,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => true,
                'required' => false,
                'weight' => 0,
                'title' => [
                    'fr' => 'Tag d\'abécédaire',
                    'en' => 'Alphabet book tag',
                    'de' => 'Alphabetbuch-Tag',
                    'nl' => 'Alfabetboek tag',
                    'es' => 'Etiqueta de libro de alfabeto',
                    'pt' => 'Tag de livro de alfabeto',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => 0,
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['alphabet_books_tags'],
                    'cardinality' => -1,
                ],
            ]
        );

        $bridgeContentType->contentTypeCreateOrUpdateField(
            type: 'alphabet_books_tags',
            fieldName: 'color',
            options: [
                'name' => 'color',
                'searchable' => false,
                'translatable' => true,
                'required' => false,
                'weight' => 3,
                'title' => [
                    'fr' => 'Couleur',
                    'en' => 'Color',
                    'de' => 'Farbe',
                    'nl' => 'Kleur',
                    'es' => 'Color',
                    'pt' => 'Cor',
                ],
                'widget' => [
                    'type' => BridgeContentType::INSIDE_COLOR_PICKER_WIDGET,
                    'settings' => [],
                    'weight' => 3,
                ],
                'type' => BridgeContentType::TEXT_FIELD,
                'settings' => [
                    'max_length' => 255,
                    'is_ascii' => false,
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ]
        );
    }
}
