<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema as InsideSchema;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

class FixUriFieldForDmsLink extends Migration
{
    use CreateContentTypes;

    public $withinTransaction = false;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        $this->getBridge()?->contentTypeCreateOrUpdateField('dms_link', 'uri', $this->options([
            "required" => true,
            "translatable" => false,
            "weight" => 1,
            "widget" => "uri",
            "searchable" => false,
            "search_result_field" => true,
        ]), 1);
    }

    private function options(array $origin): array
    {
        return [
            'name' => 'uri',
            'type' => BridgeContentType::URI_FIELD,
            'searchable' => data_get($origin, 'searchable', false),
            'translatable' => data_get($origin, 'translatable', false),
            'search_result_field' => data_get($origin, 'search_result_field', true),
            'default' => data_get($origin, 'default', ''),
            'required' => data_get($origin, 'required', true),
            'weight' => data_get($origin, 'weight', 1),
            'title' => data_get($origin, 'title', [
                'fr' => 'Lien',
                'en' => 'Link',
                'es' => 'Enlace',
                'de' => 'Verknüpfung',
                'nl' => 'Link',
                'pt' => 'Link',
            ]),
            'description' => data_get($origin, 'description', [
                'fr' => '',
                'en' => '',
                'es' => '',
                'de' => '',
                'nl' => '',
                'pt' => '',
            ]),
            'placeholder' => data_get($origin, 'placeholder', [
                'fr' => 'https//example.com',
                'en' => 'https//example.com',
                'es' => 'https//example.com',
                'de' => 'https//example.com',
                'nl' => 'https//example.com',
                'pt' => 'https//example.com',
            ]),
            'widget' => [
                'type' => BridgeContentType::INSIDE_LINK_WIDGET,
            ],
        ];
    }
}
