<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema;
use Inside\Content\Models\Contents\Users;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;

class ChangeUserMissionToLongText extends Migration
{
    public function up(): void
    {
        $bridgeContentType = new BridgeContentType();
        $bridgeContent = new BridgeContent();

        $bridgeContentType->contentTypeCreateOrUpdateField(
            'users',
            'temp_mission',
            [
                'name' => 'temp_mission',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 10,
                'title' => [
                    'fr' => 'Temp Mission',
                ],
                'widget' => [
                    'type' => BridgeContentType::LONGTEXT_WIDGET,
                    'settings' => [
                        'rows' => 5,
                        'placeholder' => '',
                    ],
                    'weight' => 10,
                ],
                'type' => BridgeContentType::TEXTAREA_FIELD,
                'settings' => [
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ]
        );

        Users::select('missions', 'uuid')->get()->each(function ($user) use ($bridgeContent) {
            if (! $user->missions) {
                return;
            }

            try {
                $bridgeContent->contentUpdate('users', [
                    'uuid' => $user->uuid,
                    'temp_mission' => $user->missions,
                ]);
            } catch (Exception) {
            }
        });

        if (Schema::hasField('users', 'missions')) {
            $bridgeContentType->contentTypeDeleteField('user', 'user', 'missions');
        }

        $bridgeContentType->contentTypeCreateOrUpdateField(
            'users',
            'missions',
            [
                'name' => 'missions',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 10,
                'title' => [
                    'fr' => 'Mission',
                ],
                'widget' => [
                    'type' => BridgeContentType::LONGTEXT_WIDGET,
                    'settings' => [
                        'rows' => 5,
                        'placeholder' => '',
                    ],
                    'weight' => 10,
                ],
                'type' => BridgeContentType::TEXTAREA_FIELD,
                'settings' => [
                    'case_sensitive' => false,
                    'cardinality' => 1,
                ],
            ]
        );

        Users::select('uuid', 'temp_mission')->each(
            function ($user) use ($bridgeContent) {
                try {
                    $bridgeContent->contentUpdate('users', ['uuid' => $user->uuid, 'missions' => $user->temp_mission]);
                } catch (Exception) {
                }
            }
        );

        if (Schema::hasField('users', 'temp_mission')) {
            $bridgeContentType->contentTypeDeleteField('user', 'user', 'temp_mission');
        }
    }
}
