<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class SetUsersFieldsToEditable extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $fields = [
            'function',
            'phone',
            'mobile_phone',
            'image',
            'birthday',
            'arrival_date',
            'user_description',
            'users',
            'link'
        ];
        foreach ($fields as $field) {
            $bridge->updateFieldOptions('users', $field, [
                'editable' => true,
            ]);
        }
    }
}
