<?php

use Inside\Content\Models\Contents\Users;
use Inside\Host\Bridge\BridgeContent;

return [
    'postfilter' => function ($users) {
        $banned = Users::where('disable_user_import', true)->pluck('email')->toArray();

        return $users->reject(function ($user) use ($banned) {
            return match (true) {
                $user->givenName === null => true,
                $user->surname === null => true,
                $user->onPremisesExtensionAttributes->extensionAttribute1 === 'email' => true,
                !$user->accountEnabled => true,
                in_array($user->mail, $banned) => true,
                default => false,
            };
        });
    },
    'sync_attributes' => [
        'mail' => 'mail',
        'name' => 'mail',
        'langcode' => function () {
            return 'fr';
        },
        'status' => function () {
            return 1;
        },
        'firstname' => 'givenName',
        'lastname' => 'surname',
    ],
];
