<?php

return [
    '_meta' => [
        'type' => 'newsletters',
        'fieldsPrefix' => ''
    ],
    'logo' => [
        'showLogo'  => true,
        'logoUrl'   => 'vendor/maecia/ecos-back/resources/assets/img/newsletter/logo.png',
        'logoWidth' => 200
    ],
    'banner'       => [
        'backgroundImageUrl' => 'vendor/maecia/ecos-back/resources/assets/img/newsletter/bg.png',
        'backgroundColor' => '#ffff'
    ],
    'introduction' => [
        'introductionFieldName' => 'newsletter_introduction',
        'textColor' => '#2C3E50',
        'showGreetings' => false
    ],
    'sections'     => [
        'news'       => [
            'sectionTitleStrKey' => 'newsletter.news_title',
            'types' => ['news'],
            'dateFormat' => '%d/%m/%Y',
            'showCategoryTitle' => true,
            'showIntroduction' => true,
            'defaultCategoryColor' => '#51D8F8',
            'link' => [
                'sectionLinkUrl'  => 'actualites',
                'sectionTextColor' => '#2C3E50',
            ],
        ],
        'events'     => [
            'sectionTitleStrKey' => 'newsletter.events_title',
            'types' => ['events'],
            'sorts' => ['date:desc'],
            'dateFormat' => '%d/%m/%Y',
            'categoryFieldName' => 'events_categories',
            'defaultCategoryColor' => '#51D8F8',
            'link' => [
                'sectionLinkUrl'   => 'events',
                'sectionTextColor' => '#2C3E50',
            ],
        ],
        'documents'  => [
            'sectionTitleStrKey' => 'newsletter.documents_title',
            'types'           => ['documents'],
            'sorts' => ['created_at:desc'],
            'imageStyle' => 'medium',
            'dateFormat' => '%d/%m/%Y',
            'link'            => [
                'sectionLinkStrKey' => 'newsletter.see_all_documents',
                'sectionLinkUrl' => 'bibliotheque',
                'sectionTextColor' => '#2C3E50'
            ],
        ],
    ],
    'socials'      => [
        'backgroundColor' => '#51D8F8',
        'links' => [
            'facebook' => [
                'titleStrKey' => '',
                'url' => 'https://www.facebook.com/ecosystem.eco',
            ],
            'twitter' => [
                'titleStrKey' => '',
                'url' => 'https://twitter.com/ecosystem_eco',
            ],
            'linkedin' => [
                'titleStrKey' => '',
                'url' => 'https://www.linkedin.com/company/ecosystem-eco/',
            ],
            'instagram' => [
                'titleStrKey' => '',
                'url' => 'https://www.instagram.com/ecosystem.eco/',
            ],
            'youtube' => [
                'titleStrKey' => '',
                'url' => 'https://www.youtube.com/ecosystem_eco',
            ]
        ],
    ],
    'footer'       => [
        'backgroundColor' => '#ffffff',
        'unsubscribeTextColor' => '#818181',
        'unsubscribeTextStrKey' => 'newsletter.unsubscribe.warning'
    ],
];
