<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class UpdateArrivalDate extends Migration
{
    public function up(): void
    {
        $bridgeContentType = new BridgeContentType();

        $bridgeContentType->contentTypeCreateOrUpdateField(
            type: 'users',
            fieldName: 'arrival_date',
            options: [
                'name' => 'arrival_date',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'editable' => true,
                'weight' => 11,
                'title' => [
                    'fr' => 'Date d\'entrée',
                ],
                'widget' => [
                    'type' => BridgeContentType::TIMESTAMP_WIDGET,
                    'settings' => [],
                    'weight' => 11,
                ],
                'type' => BridgeContentType::TIMESTAMP_FIELD,
                'settings' => [
                    'cardinality' => 1,
                ],
                'front_field_config' => '{"input": "input-day", "toDate": true}',
            ],
            weight: 11,
        );
    }
}
