<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema;
use Inside\Host\Bridge\BridgeContentType;

class UpdateProjectsType extends Migration
{
    public function up(): void
    {
        $bridgeContentType = new BridgeContentType();

        $bridgeContentType->contentTypeCreateOrUpdateField(
            'projects',
            'progress_rate',
            [
                'name' => 'progress_rate',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 1,
                'title' => [
                    'fr' => "Pourcentage d'avancement",
                ],
                'widget' => [
                    'type' => BridgeContentType::NUMBER_WIDGET,
                    'settings' => [],
                    'weight' => 1,
                ],
                'type' => BridgeContentType::INTEGER_FIELD,
                'settings' => [
                    'cardinality' => 1,
                ],
                'default' => 0,
            ],
        );

        $bridgeContentType->contentTypeCreateOrUpdateField(
            'projects',
            'sponsors',
            [
                'name' => 'sponsors',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 2,
                'title' => [
                    'fr' => 'Sponsors',
                ],
                'widget' => [
                    'type' => BridgeContentType::AUTOCOMPLETE_WIDGET,
                    'settings' => [],
                    'weight' => 2,
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => 'users',
                    'cardinality' => -1,
                ],
            ],
        );

        $bridgeContentType->switchCardinalityFromUnaryToMultiple('projects', 'project_manager', true);
    }
}
