<?php

declare(strict_types=1);

use Illuminate\Support\Facades\Artisan;
use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Content\Facades\ContentBlueprints;
use Inside\Host\Migrations\CreateContentTypes;
use Inside\Content\Models\Contents\Custom;
use Inside\Host\Bridge\BridgeContent;

final class CreateAlphabetContentTypeEnableAlphabetFeatureAndCreateCustomPage extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        ContentBlueprints::generateContent('alphabet_books_categories');
        ContentBlueprints::generateContent('alphabet_books');
        $this->finishUp();

        Artisan::call("models:rebuild");

        $bridgeContentType = new BridgeContentType();
        $bridgeContentType->updateContentTypeOptions('alphabet_books', [
            'listing_type' => 'content',
        ]);
        Artisan::call('db:seed', [
            '--class' => 'Inside\\Content\\Seeders\\AlphabetCategoriesSeeder',
            '--force' => true,
        ]);

        $custom = [
            'title' => 'Glossaire',
            'custom_slug' => 'alphabet',
            'redirection_page' => 'AlphabetBooksPage',
        ];

        $locale = config('app.locale');

        $original = Custom::findOrFail($this->createCustom($custom, $locale));

        collect(list_languages())
            ->reject($locale)
            ->each(fn (string $language) => $this->createCustom($custom, $language, $original));
    }

    public function createCustom(array $data, string $langcode, ?Custom $original = null): ?string
    {
        $data['langcode'] = $langcode;

        if ($original instanceof Custom) {
            $data['uuid_host'] = $original->uuid_host;
        }

        $custom = Custom::query()
            ->where('custom_slug', $data['custom_slug'])
            ->where('redirection_page', $data['redirection_page'])
            ->where('langcode', $langcode)
            ->first();

        if ($custom instanceof Custom) {
            $data['uuid'] = $custom->uuid;
        }

        $bridgeContent = new BridgeContent();
        return $bridgeContent->contentInsert('custom', $data, ! isset($data['uuid']), true);
    }
}
