<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Illuminate\Support\Facades\Artisan;

class AddFieldsToUserForCollabFiles extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        $this->migrateContent('referent_groups');
        $this->migrateContent('services');
        $this->migrateContent('users');
        $this->finishUp();

        $bridge = new BridgeContentType();
        $bridge->contentTypeDeleteField('user', 'user', 'user_description');
    }
}
