<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class addDisableUserImportField extends Migration
{
    public function up(): void
    {
        $bridgeType = new BridgeContentType();
        $bridgeType->contentTypeCreateOrUpdateField('users', 'disable_user_import', [
            'name' => 'disable_user_import',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 16,
            'title' => [
                'fr' => 'Retirer l’utilisateur de l’import journalier',
            ],
            'widget' => [
                'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [
                    'display_label' => true,
                ],
                'weight' => 16,
            ],
            'type' => BridgeContentType::BOOLEAN_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
            'default' => false,
        ], 16);
    }
}
