<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Content\Models\Contents\BranchesAndGroups;

class CreateBranchesIntroductionFillItWithOldIntroductionValues extends Migration
{
    /**
     * @return void
     * @throws \Drupal\Core\Entity\EntityStorageException
     * @throws \Inside\Host\Exceptions\ColumnAlreadyExistsException
     */
    public function up(): void
    {
        $bridgeContentType = new BridgeContentType();
        $bridgeContent = new BridgeContent();

        $bridgeContentType->contentTypeCreateOrUpdateField(
            'branches_and_groups',
            'branches_introduction',
            [
                'name' => 'branches_introduction',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 1,
                'title' => [
                    'fr' => 'Introduction',
                ],
                'widget' => [
                    'type' => BridgeContentType::WYSIWYG_WIDGET,
                    'settings' => [],
                    'weight' => 1,
                ],
                'type' => BridgeContentType::WYSIWYG_FIELD,
                'settings' => [
                    'cardinality' => 1,
                ],
            ]
        );

        $branchesAndGroups = BranchesAndGroups::query()->get();

        foreach ($branchesAndGroups as $brancheAndGroup) {
            $bridgeContent->contentUpdate('branches_and_groups', [
                'type' => 'node',
                'bundle' => 'branches_and_groups',
                'uuid' => $brancheAndGroup->uuid,
                'branches_introduction' => $brancheAndGroup->introduction
            ]);
        }

        $bridgeContentType->contentTypeDeleteField('node', 'branches_and_groups', 'introduction');
    }
}
