<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class UpdateFoldersFieldInBranchesAndGroupsType extends Migration
{
    /**
     * @return void
     * @throws \Drupal\Core\Entity\EntityStorageException
     * @throws \Inside\Host\Exceptions\ColumnAlreadyExistsException
     */
    public function up()
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeDeleteField('node', 'branches_and_groups', 'folders');
        $bridge->contentTypeCreateOrUpdateField(
            'branches_and_groups',
            'branches_folders',
            [
                'name' => 'folders',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 4,
                'title' => [
                    'fr' => 'Dossiers',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => 4,
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['folders'],
                    'cardinality' => -1,
                ],
                'selectable_all' => true,
            ]
        );
    }
}
