<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class CreateQualityPageTypes extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        $this->migrateContent('quality_folders');
        $this->migrateContent('quality_documents');
        $this->migrateContent('qualities');

        $bridge = new BridgeContentType();
        $bridge->contentTypeCreateOrUpdateField('quality_folders', 'qualities', [
            'name' => 'qualities',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 4,
            'title' => [
                'fr' => 'qualité',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 4,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['qualities'],
                'cardinality' => -1,
            ],
            'selectable_all' => true,
        ]);
    }
}
