import { storage } from '@inside-library/helpers/Storage'

export default [
  {
    name: 'HomePage',
    component: () => import('../pages/Homepage'),
    meta: { disabled: false }
  },
  {
    path: '/sites-selection',
    name: 'Sites',
    component: () => import('../components/site/SiteSelection'),
    meta: { logout: true }
  },
  {
    name: 'ToolsDashboard',
    path: {
      fr: '/tableau-de-bord',
      en: '/dashboard'
    },
    component: () => import('../pages/DashboardToolsListingPageCustoms')
  },
  {
    name: 'Dashboard',
    beforeEnter: (to, from, next) => {
      const { clients } = to.query

      if (
        (!clients && storage.get('client') === 'undefined') ||
        storage.get('client').lang !== to.meta.lang
      ) {
        next({ name: `ToolsDashboard-${to.meta.lang}` })
      }

      next()
    },
    path: {
      fr: '/tableau-de-bord-client',
      en: '/dashboard-customer'
    },
    component: () => import('../pages/DashboardListingPageCustoms')
  },
  {
    name: 'MySpace',
    path: {
      fr: '/mon-espace',
      en: '/my-space'
    },
    component: () => import('../pages/GedMySpacePageCustoms')
  },
  {
    name: 'SharedDocuments',
    path: {
      fr: '/documents-partages',
      en: '/shared-documents'
    },
    component: () => import('../pages/GedSharedDocumentsPageCustoms')
  },
  {
    name: 'GlobalSearchPage',
    meta: { disabled: true }
  },
  {
    name: 'SimplePage',
    meta: { disabled: false, content: 'pages' }
  }
]
