import { storage } from '@inside-library/helpers/Storage'
import { http } from '@inside-library/helpers/Http'

export default {
  methods: {
    async $_fetchUserSites() {
      try {
        const { data } = await http.get('content/users', {
          fields: [
            {
              sites: {
                fields: ['uuid', 'title', 'image', 'langcode'],
                filters: {
                  sort: 'weight:asc',
                  'status:eq': 1
                }
              }
            }
          ],
          filters: { 'uuid:eq': this.getUserInfos.uuid }
        })

        return this.getCheckedData(data, [0, 'sites', 'data'], [])
      } catch (err) {
        throw new Error(err)
      }
    },
    getCurrentSite(callback) {
      const url = 'content/sites'
      const params = {
        params: {
          filters: JSON.stringify({
            title: storage.get('site').title,
            langcode: this.$_currentLang
          })
        }
      }

      this.get(url, params).then(res => {
        callback(res)
      })
    }
  }
}
