import { storage } from '@inside-library/helpers/Storage'

export default {
  'inside-archives': {
    isEnabled: true
  },
  'inside-users': {
    profil: {
      enabledProfilTabs: [
        { name: 'profil', restrictions: [], icon: 'user' },
        { name: 'password', restrictions: [] }
      ]
    },
    login: {
      useGradient: false,
      useImage: true,
      useBackgroundImage: true,
      successCallback: data => {
        const isManager = data.permissions.roles.includes('key_account_manager')
        const langcode = data.langcode

        // if key account manager, redirects to the dashboard
        if (isManager) {
          storage.set(
            'target-page',
            langcode === 'en' ? '/dashboard' : '/tableau-de-bord'
          )
        } else {
          storage.set('target-page', '/sites-selection')
        }
      }
    },
    extraFields: [
      { clients: ['uuid', 'title', 'image', 'machine_name'] },
      { sites: ['uuid', 'title'] },
      'is_key_account_manager'
    ]
  },
  'inside-notifications': {
    listingItemAttributes: {
      action: (data, vm) => {
        vm.$router.push({
          path: `/${data.url}`,
          query: {
            site: data.site.uuid,
            clients: data.client.machine_name,
            siteTitle: data.site.name
          }
        })
      }
    }
  },
  'inside-ged': {
    useV2: true
  },
  'inside-toasters': {
    containerConfig: {
      max: 1
    }
  }
}
