import { http } from '@inside-library/helpers/Http'

let selection = false

export default {
  pos: 7,
  group: 'postLogin',
  fn: async ({ to, router, store }) => {
    if (!selection && to.path !== '/profil') {
      try {
        const { data } = await http.get('content/users', {
          fields: [
            {
              sites: {
                fields: ['count', 'title'],
                filters: {
                  sort: 'weight:asc',
                  'status:eq': 1
                }
              }
            }
          ],
          filters: { 'uuid:eq': store.getters.getUserInfos.uuid }
        })

        if (data[0].sites.count === 1) {
          router.push('/')
        }
      } catch (err) {
        throw new Error(err)
      }
    }
    selection = true
  }
}
