import { storage } from '@inside-library/helpers/Storage'

let logged = false

export default {
  pos: 6,
  group: 'postLogin',
  fn: async ({ store }) => {
    if (!logged) {
      const user = storage.get('current-user')

      let client = storage.get('client') || user.clients.data[0] || {}
      let site = storage.get('site') || user.sites.data[0] || {}

      if (client) {
        store.commit('setUserInformation', { key: 'client', value: client })
      }

      if (site) {
        store.commit('setUserInformation', { key: 'site', value: site })
      }

      storage.set('toaster', 'false')
    }

    logged = true
  }
}
